-- Level Manager
-- load the static definitions
require("scripts/basicSetting.lua")
dofile("scripts/LevelDefines.lua");
require("scripts/luaDebug.lua");

LevelManager = nil;
LevelManager = {};
LevelManager.__index = LevelManager;

function LevelManager.create()
	DebugOut("LevelManager.create()");

	local mgr = {};
	setmetatable(mgr, LevelManager);

	mgr.table_list = nil;
	mgr.table_list = {};
	
	mgr.quinnEventList = nil;
	mgr.quinnEventList = {};
	
	mgr.guest_list = nil;
	mgr.guest_list = {};

	mgr.reseating_list = nil;
	mgr.reseating_list = {};

	mgr.level_settings = nil;
	mgr.level_settings = DefaultLevel;

	mgr.background_image = "images/bg_backyard";
	
--	PrintTabTable( "table list", mgr.table_list );
	
	return mgr;
end


function LevelManager:AddNewTable(tableID, numChairs, x, y, tableImage, markImage, color)
	new_table = {};
	new_table.tableID = tableID;
	new_table.numChairs = numChairs;
	new_table.x = x;
	new_table.y = y;
	new_table.color = color;
	new_table.tableImage = tableImage;
	new_table.markImage = markImage;

--	PrintTabTable( "AddNewTable -- new_table", new_table );

	table.insert( self.table_list, new_table );
end

-- Support for old level files
function LevelManager:AddTable(tableID, numChairs)

	new_table = {};
	new_table.tableID = tableID;
	new_table.numChairs = numChairs;

-- Would be 100% better if we could call AddNewTable with correct params but self
-- isn't working when I try that... So here goes the brute force.

	if ( tableID == 1 ) then
-- AddNewTable( tableID, numChairs, 200, 215, "assets/images/table/bluetable", "assets/images/food/item_mark1", "Blue" );
		new_table.x = 200;
		new_table.y = 215;
		new_table.color = "B";
		new_table.tableImage = "assets/images/table/bluetable";
		new_table.markImage = "assets/images/food/item_mark1";
	elseif tableID == 2 then
-- AddNewTable( tableID, numChairs, 250, 362, "assets/images/table/redtable", "assets/images/food/item_mark2", "Red" );
			new_table.x = 250;
			new_table.y = 362;
			new_table.color = "R";
			new_table.tableImage = "assets/images/table/redtable";
			new_table.markImage = "assets/images/food/item_mark2";
	elseif tableID == 3 then
-- AddNewTable( tableID, numChairs, 346, 362, "assets/images/table/bluetable", "assets/images/food/item_mark3", "Blue" );
		new_table.x = 346;
		new_table.y = 362;
		new_table.color = "B";
		new_table.tableImage = "assets/images/table/bluetable";
		new_table.markImage = "assets/images/food/item_mark3";
	elseif tableID == 4 then
-- AddNewTable( tableID, numChairs, 136, 362, "assets/images/table/redtable", "assets/images/food/item_mark4", "Red" );
		new_table.x = 136;
		new_table.y = 362;
		new_table.color = "R";
		new_table.tableImage = "assets/images/table/redtable";
		new_table.markImage = "assets/images/food/item_mark6";
	elseif tableID == 5 then
-- AddNewTable( tableID, numChairs, 241, 487, "assets/images/table/bluetable", "assets/images/food/item_mark5", "Blue" );	}
		new_table.x = 241;
		new_table.y = 487;
		new_table.color = "B";
		new_table.tableImage = "assets/images/table/bluetable";
		new_table.markImage = "assets/images/food/item_mark5";
	else
-- AddNewTable( tableID, numChairs, 578, 305, "assets/images/table/redtable", "assets/images/food/item_mark6", "Red" );
		new_table.x = 578;
		new_table.y = 305;
		new_table.color = "R";
		new_table.tableImage = "assets/images/table/redtable";
		new_table.markImage = "assets/images/food/item_mark6";
	end
	
--	PrintTabTable( "AddTable -- new_table", new_table );
	table.insert( self.table_list, new_table );
end

function LevelManager:AddGuests(numGuests, requiredGuests, restrictedGuests)
	generated_guests = 0
	possible_guests = {}

	-- first, grab the total set of possible guests
	for key, value in pairs(GuestTypeList) do
		possible_guests[key] = value;
	end

	-- remove any of the restricted guest types	
	for restricted_key, restricted_value in ipairs(restrictedGuests) do
		for possible_key, possible_value in ipairs(possible_guests) do
			if possible_value == restricted_value then
				table.remove(possible_guests, possible_key);
				break;
			end
		end
	end

	-- if there are any 'required' guests, add them to the guest list first
	for required_key, required_value in ipairs(requiredGuests) do
		if generated_guests == numGuests then
			break;
		end

		table.insert(self.guest_list, self.GenGuest(required_value));

		generated_guests = generated_guests + 1;

	end


	-- if we have any room for more guests, grab them from our guest list
	while generated_guests < numGuests do
		guest_index = GetRandomRange(1, table.getn(possible_guests))

		table.insert(self.guest_list, self.GenGuest(possible_guests[guest_index]) );

		generated_guests = generated_guests + 1;
	end
end

function LevelManager:AddGuest(guestData)
	table.insert(self.guest_list, guestData);
end

function LevelManager.GenGuest(guestType)
	-- return a guest based on its guest type
	for guest_key, guest_value in ipairs(GuestDefinitionList) do
		if guest_value.type == guestType then

			temp_guest = {};

			for key, value in pairs(guest_value) do
				temp_guest[key] = value;
			end

			return temp_guest;
		end
	end

	return {};
end

function LevelManager:SetSeatingGroup(lowID, highID, waitTime)

	index = lowID

	while (index <= highID) do
		self.guest_list[index].waitBeforeSit = waitTime;
		index = index + 1
	end
end

function LevelManager:SetBaseAttribute(guestTypes, attribute, value)

	-- increment through the guest types to change
	for change_key, change_value in ipairs(guestTypes) do
		
		for guest_key, guest_value in ipairs(self.guest_list) do
			
			if(guest_value.type == change_value) then
				-- we've found the right type of guest to change, now change the attribute
				self.guest_list[guest_key][attribute] = value;
			end
		end
	end
end

function LevelManager:AdjustGuestTolerance(percentage)
--	counter = 0;
	
	target_pct = tonumber(percentage)/100;

	-- increment through the guest list
	for guest_key, guest_value in ipairs(self.guest_list) do
		--guest_value.tolerance = guest_value.tolerance - tolerance_difference;
		guest_value.tolerance = tonumber(guest_value.tolerance) * target_pct;		
--		counter = counter + 1;
--		DebugOut("LevelManager:AdjustGuestTolerance() -- guest" .. counter );
	end
end

function LevelManager:AddReseatingRequestForGuest(time,guestType)
	table.insert(self.reseating_list, time);
	table.insert(self.reseating_list, guestType);
end

function LevelManager:AddReseatingRequest(time)
	table.insert(self.reseating_list, time);
	table.insert(self.reseating_list, -1);
end

-- Level Settings Functionality
function LevelManager:SetBackgroundImage(imgString)
	self.background_image = imgString;
end

function LevelManager:GetBackgroundImage()
	return self.background_image;
end

function LevelManager:SetChairImage(imgStrig)
	self.level_settings.chair_image = imgStrig;
end

function LevelManager:SetLevelNumber(map,level)

	self.level_settings.map = map;
	self.level_settings.level = level;
end

function LevelManager:SetLevelScores(passScore, highScore)
	self.level_settings.passScore = passScore;
	self.level_settings.highScore = highScore;
end

function LevelManager:SetLevelTime(totalTime)
	self.level_settings.totalTime = totalTime;
end

function LevelManager:SetMusic(slowMusic, fastMusic, fastMusic2)
	self.level_settings.slowMusic = slowMusic;
	self.level_settings.fastMusic = fastMusic;
	self.level_settings.fastMusic2 = fastMusic2;
end

function LevelManager:AddTutorial(firstStep, lastStep, guestLock)
	new_tutorial = {}

	if((firstStep ~= nil) and (firstStep ~= 0)) then
		new_tutorial.firststep = firstStep;
	end

	new_tutorial.steps = lastStep;
	
	if(guestLock == true) then
		new_tutorial.guestlock = 1;
	else
		new_tutorial.guestlock = 0;
	end

	self.level_settings.tutorial = new_tutorial;
end


function LevelManager:SetLevelSetting(attribute, value)
	self.level_settings[attribute] = value;

	-- transparency hack for the dog/bridesmaids switch since both use the same parameters
	if attribute == "dogDelay" then
		self.level_settings["bridesmaidsDelay"] = value;
		self.level_settings["bridesmaidsUseDog"] = 1;
	end
	if attribute == "dogChance" then
		self.level_settings["bridesmaidsChance"] = value;
		self.level_settings["bridesmaidsUseDog"] = 1;
	end
end

function LevelManager:AddQuinnEvent( effectsPath, x, y, delay )
	newQuinnEvent = {};

	newQuinnEvent.effectsPath = effectsPath;
	newQuinnEvent.delay = delay;
	newQuinnEvent.x = x;
	newQuinnEvent.y = y;
	
--	PrintTabTable( "AddQuinnEvent -- newQuinnEvent", newQuinnEvent );

	table.insert( self.quinnEventList,
					newQuinnEvent );
end

-- Generators
function LevelManager:GenerateGameObject()
	game_object = {}

	-- Add the table list
	game_object.availableTables = self.table_list;

	-- Add the quinn event list
	game_object.quinnEvents = self.quinnEventList;
	
	-- Randomize the guest list before you set it ?

	-- Now add the guest list
	game_object.guestList = self.guest_list;

	-- Now add the list of reseating requests
	game_object.reseatingList = self.reseating_list;

	-- dump to log
	-- PrintTabTable(game_object);

	-- clear the tutorial steps
	TutorialSteps = {}

	return game_object;
end

function LevelManager:GenerateLevelSettings()
	return self.level_settings;
end